/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.PlayerDataRequirement;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;

public record EntityTempData(EntityRequirement entity, double temperature, double range, Temperature.Units units, Optional<PlayerDataRequirement> playerRequirement, Optional<List<String>> requiredMods) {
    public static final Codec<EntityTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityRequirement.getCodec().fieldOf("entity").forGetter(EntityTempData::entity), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(EntityTempData::temperature), (App)Codec.DOUBLE.fieldOf("range").forGetter(EntityTempData::temperature), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(EntityTempData::units), (App)PlayerDataRequirement.CODEC.optionalFieldOf("player").forGetter(EntityTempData::playerRequirement), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(EntityTempData::requiredMods)).apply((Applicative)instance, EntityTempData::new));

    public boolean test(Entity entity) {
        return this.entity().test(entity);
    }

    public boolean test(Entity entity, Entity affectedPlayer) {
        return (double)entity.m_20270_(affectedPlayer) <= this.range && this.entity().test(entity) && this.playerRequirement().map(req -> req.test(affectedPlayer)).orElse(true) != false;
    }

    public double getTemperature(Entity entity, Entity affectedPlayer) {
        return CSMath.blend(0.0, this.temperature, (double)entity.m_20270_(affectedPlayer), this.range, 0.0);
    }
}

